----------------------------------------------------------------------------------------------------
-- Loader
----------------------------------------------------------------------------------------------------
-- Purpose: Loader SourceCode for Extended Cruise Control insertion into vehicles
--
-- @author John Deere 6930 @VertexDezign
----------------------------------------------------------------------------------------------------

local modDirectory = g_currentModDirectory
local modName = g_currentModName
g_extendedCruiseControlModName = modName

---Installs ExtendedCruiseControl spec in all vehicles using Drivable specialization
local function installSpecializations(vehicleTypeManager, specializationManager, _modDirectory, _modName)
    specializationManager:addSpecialization("extendedCruiseControl", "ExtendedCruiseControl", Utils.getFilename("src/vehicles/specializations/ExtendedCruiseControl.lua", _modDirectory), nil)

    for typeName, typeEntry in pairs(vehicleTypeManager:getTypes()) do
        if SpecializationUtil.hasSpecialization(Drivable, typeEntry.specializations) then
            vehicleTypeManager:addSpecialization(typeName, _modName .. ".extendedCruiseControl")
        end
    end
end

---Injects extendedCruiseControl installation
---@param typeManager table typeManager table
local function validateTypes(typeManager)
    if typeManager.typeName == "vehicle" then
        installSpecializations(g_vehicleTypeManager, g_specializationManager, modDirectory, modName)
    end
end

---Overwritten function: SpeedMeterDisplay.drawCruiseControlText
---Injects extendedCruiseControl drawings
---@param speedMeterDisplay SpeedMeterDisplay instance of speedMeterDisplay
---@param superFunc function original function
local function inject_drawSpeedMeter(speedMeterDisplay, superFunc, ...)
    local cruiseControlElement = speedMeterDisplay.cruiseControl

    if cruiseControlElement == nil or not cruiseControlElement:getIsVisible() then
        superFunc(speedMeterDisplay, ...)
        return
    end

    if speedMeterDisplay.vehicle == nil or speedMeterDisplay.vehicle.spec_extendedCruiseControl == nil then
        superFunc(speedMeterDisplay, ...)
        return
    end

    local posX, posY = cruiseControlElement:getPosition()

    -- render active speed group text
    local activeSpeedGroup = speedMeterDisplay.vehicle.spec_extendedCruiseControl.activeSpeedGroup
    if activeSpeedGroup ~= nil then
        setTextAlignment(RenderText.ALIGN_RIGHT)
        setTextColor(cruiseControlElement.r, cruiseControlElement.g, cruiseControlElement.b, cruiseControlElement.a)
        setTextBold(true)

        local groupText = ("%d"):format(activeSpeedGroup)
        renderText(posX, posY - speedMeterDisplay.cruiseControlTextOffsetY / 7, speedMeterDisplay.cruiseControlTextSize * 0.7, groupText)
    end

    -- render permanent cruise control character
    local permanentActive = speedMeterDisplay.vehicle.spec_extendedCruiseControl.permanentActive
    if permanentActive ~= nil and permanentActive then
        setTextAlignment(RenderText.ALIGN_RIGHT)
        setTextColor(cruiseControlElement.r, cruiseControlElement.g, cruiseControlElement.b, cruiseControlElement.a)
        -- setTextColor(unpack(SpeedMeterDisplay.COLOR.CRUISE_CONTROL_ON))
        setTextBold(true)

        renderText(posX, posY, speedMeterDisplay.cruiseControlTextSize * 0.7, "P")
    end

    superFunc(speedMeterDisplay, ...)
end

---Initialize the mod
local function init()
    TypeManager.validateTypes = Utils.prependedFunction(TypeManager.validateTypes, validateTypes)
    SpeedMeterDisplay.drawSpeedMeter = Utils.overwrittenFunction(SpeedMeterDisplay.drawSpeedMeter, inject_drawSpeedMeter)
end

init()
