﻿----------------------------------------------------------------------------
-- ©Copyright: ViperGTS96®--------------------------------------------------
----------------------------------------------------------------------------
--------------------"The simplest design is the best design." --------------
----------------------------------------------------------------------------
----------------------------------------------------------------------------

function realDirtColor:Initialize()
	realDirtColor.modDirectory  = g_currentModDirectory;
	local modDesc = loadXMLFile("modDesc", realDirtColor.modDirectory .. "modDesc.xml");
	realDirtColor.version = getXMLString(modDesc, "modDesc.version");
	realDirtColor.title = getXMLString(modDesc, "modDesc.title.en");
	realDirtColor.author = getXMLString(modDesc, "modDesc.author");
	delete(modDesc);
	----------<Initialize New Dirt Colors>----------
	realDirtColor.colors = {};
	realDirtColor.colors.brownMud = {};
	realDirtColor.colors.brownMud.r, realDirtColor.colors.brownMud.g, realDirtColor.colors.brownMud.b = 0.059, 0.038, 0.021;
	realDirtColor.colors.mud = realDirtColor.colors.brownMud;
	realDirtColor.colors.redMud = {};
	realDirtColor.colors.redMud.r, realDirtColor.colors.redMud.g, realDirtColor.colors.redMud.b = 0.34, 0.09, 0.06;
	realDirtColor.colors.grass = {};
	realDirtColor.colors.grass.r, realDirtColor.colors.grass.g, realDirtColor.colors.grass.b  = 0.035, 0.055, 0.006;
	realDirtColor.colors.chaff = {};
	realDirtColor.colors.chaff.r, realDirtColor.colors.chaff.g, realDirtColor.colors.chaff.b  = 0.09, 0.1, 0.002;
	realDirtColor.colors.lime = {};
	realDirtColor.colors.lime.r, realDirtColor.colors.lime.g, realDirtColor.colors.lime.b = 0.82, 0.9, 0.82;
	realDirtColor.colors.snow = {};
	realDirtColor.colors.snow.r, realDirtColor.colors.snow.g, realDirtColor.colors.snow.b  = 0.83, 0.83, 0.9;
	realDirtColor.colors.manure = {};
	realDirtColor.colors.manure.r, realDirtColor.colors.manure.g, realDirtColor.colors.manure.b  = 0.176, 0.099, 0.025;
	realDirtColor.colors.slurry = {};
	realDirtColor.colors.slurry.r, realDirtColor.colors.slurry.g, realDirtColor.colors.slurry.b = 0.059, 0.046, 0.021;
	realDirtColor.colors.redDirt = {};
	realDirtColor.colors.redDirt.r, realDirtColor.colors.redDirt.g, realDirtColor.colors.redDirt.b  = 0.65, 0.18, 0.1;
	------<Excluded from independent mode>----------
	realDirtColor.excludedToolTypes = { "PLANTERS", "SEEDERS", "WEEDERS", "TEDDERS", "WINDROWERS", "PLOWS", "SUBSOILERS", "CULTIVATORS", "DISCHARROWS", "POWERHARROWS", "SPADERS", "ROLLERS" }
	---------<Dirt Color Change Speeds>----------
	realDirtColor.speeds = {};  --Lower the value to lower the speed.
	realDirtColor.speeds.body = 0.005; --Base Value Multiplier
	realDirtColor.speeds.wheels = realDirtColor.speeds.body*2; --Base Value Multiplier
	realDirtColor.speeds.boost = 2.0; --Multiplier
	realDirtColor.speeds.megaBoost = 7.5; --Multiplier
	realDirtColor.speeds.revert = 20.0; --Dividend
	realDirtColor.speeds.revertFast = realDirtColor.speeds.revert/2;--Dividend
	realDirtColor.speeds.white = realDirtColor.speeds.revert/4; --Dividend
	-----------<Initialize XML Settings>------------
	realDirtColor.simpleMode = false;
	realDirtColor.coldSlowsColor = false;
	realDirtColor.writeToLog = false;
	realDirtColor.debugging = false;
	realDirtColor.realTimeSnowMelting = false;
	realDirtColor.maxWheelLimit = 12;
	------------------------------------------------
	realDirtColor.minVehicleSpeed = 0.5;
	realDirtColor.maxSpeedChange = 20.0;
	------------------------------------------------
end;